% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_interface.R
\name{startProcess}
\alias{startProcess}
\alias{endProcess}
\title{Set the status of a process to style a given button}
\usage{
startProcess(id)

endProcess(id, time = NULL, closeProgressBar = TRUE)
}
\arguments{
\item{id}{Character: button identifier}

\item{time}{\code{POSIXct} object: start time needed to show the interval
time (if \code{NULL}, the time interval is not displayed)}

\item{closeProgressBar}{Boolean: close progress bar?}
}
\value{
\code{startProcess} returns the start time of the process (may be
used as the \code{time} argument to \code{endProcess}), whereas
\code{endProcess} returns the difference between current time and \code{time}
(or \code{NULL} if \code{time} is not specified)
}
\description{
\itemize{
  \item{\code{startProcess}: Style button to show a process is in progress}
  \item{\code{endProcess}: Style button to show a process finished; also,
  closes the progress bar (if \code{closeProgressbar = TRUE}) and
  prints the difference between the current time and \code{time}}
}
}
\keyword{internal}
