% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{wilcox}
\alias{wilcox}
\alias{ttest}
\alias{levene}
\alias{fligner}
\alias{kruskal}
\alias{fisher}
\alias{spearman}
\title{Perform and display statistical analysis}
\usage{
wilcox(data, groups, stat = NULL)

ttest(data, groups, stat = NULL)

levene(data, groups, stat = NULL)

fligner(data, groups, stat = NULL)

kruskal(data, groups, stat = NULL)

fisher(data, groups)

spearman(data, groups)
}
\arguments{
\item{data}{Numeric, data frame or matrix: gene expression data or
alternative splicing event quantification values (sample names are based on
their \code{names} or \code{colnames})}

\item{groups}{List of sample names or vector containing the group name per
\code{data} value (read Details); if \code{NULL} or a character vector of
length 1, \code{data} values are considered from the same group}

\item{stat}{Data frame or matrix: values of the analyses to be performed (if
\code{NULL}, the analyses will be performed)}
}
\value{
HTML elements
}
\description{
Includes interface containing the results
}
\details{
\itemize{
  \item{\code{ttest}: unpaired t-test}
  \item{\code{wilcox}: Wilcoxon test}
  \item{\code{levene}: Levene's test}
  \item{\code{fligner}: Fligner-Killeen test}
  \item{\code{kruskal}: Kruskal test}
  \item{\code{fisher}: Fisher's exact test}
  \item{\code{spearman}: Spearman's test}
}
}
\keyword{internal}
