% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsmoothGC.R
\docType{methods}
\name{qsmoothGC}
\alias{qsmoothGC}
\title{qsmoothGC}
\usage{
qsmoothGC(object, group_factor, gc, nGroups = 50, round = TRUE, ...)
}
\arguments{
\item{object}{an object which is a \code{matrix} or 
\code{data.frame} with observations (e.g. probes or genes) on 
the rows and samples as the columns. Alternatively, 
a user can provide a \code{SummarizedExperiment} object
and the \code{assay(object, "counts")} will be used as input 
for the qsmooth normalization.}

\item{group_factor}{a group level continuous or categorial 
covariate associated with each sample or column in the 
\code{object}. The order of the \code{group_factor} must 
match the order of the columns in \code{object}.}

\item{gc}{GC-content of the features, ordered according to the features 
in \code{object}.}

\item{nGroups}{The number of equally-sized bins used to group the 
GC-content values. Groups are created using \code{Hmisc::cut2}.}

\item{round}{Should normalized values be rounded to integers?}

\item{...}{(Optional) Additional arguments passed to \code{\link{qsmooth}}.}
}
\value{
A matrix of normalized counts.
}
\description{
This function applies smoothed quantile 
normalization separately for groups of features that are
binned according to their GC-content.
}
\examples{
dat <- cbind(matrix(rnorm(1000), nrow=100, ncol=10), 
             matrix(rnorm(1000, .1, .7), nrow=100, ncol=10))
gc <- runif(n=100, min=0.2, max=0.9)
dat_qs <- qsmoothGC(object = dat, 
                   gc = gc,
                   group_factor = rep(c(0,1), each=10))

}
\references{
Van den Berge K., Chou H., Roux de Bézieux H., Street K., Risso D., Ngai J., Dudoit S. Normalization benchmark of ATAC-seq datasets shows the 
importance of accounting for GC-content effects. https://www.biorxiv.org/content/10.1101/2021.01.26.428252v2
}
