% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_qsvs.R
\name{k_qsvs}
\alias{k_qsvs}
\title{Apply num.sv algorithm to determine the number of pcs to be included}
\usage{
k_qsvs(rse_tx, mod, assayname)
}
\arguments{
\item{rse_tx}{A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class} object containing
the transcript data desired to be studied.}

\item{mod}{Model Matrix with necessary variables the you would
model for in differential expression}

\item{assayname}{character string specifying the name of the assay desired in rse_tx}
}
\value{
integer representing number of pcs to be included
}
\description{
Apply num.sv algorithm to determine the number of pcs to be included
}
\examples{
## First we need to define a statistical model. We'll use the example
## rse_tx data. Note that the model you'll use in your own data
## might look different from this model.
mod <- model.matrix(~ mitoRate + Region + rRNA_rate + totalAssignedGene + RIN,
    data = colData(rse_tx)
)

## To ensure that the results are reproducible, you will need to set a
## random seed with the set.seed() function. Internally, we are using
## sva::num.sv() which needs a random seed to ensure reproducibility of the
## results.
set.seed(20230621)
k_qsvs(rse_tx, mod, "tpm")
}
