% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qSVA.R
\name{qSVA}
\alias{qSVA}
\title{A wrapper function used to perform qSVA in one step.}
\usage{
qSVA(rse_tx, sig_transcripts = select_transcripts(), mod, assayname)
}
\arguments{
\item{rse_tx}{A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object containing the transcript data desired to be studied.}

\item{sig_transcripts}{A \code{character()} vector of transcripts that should be
associated with degradation, expected to be present in \code{rownames(rse_tx)}.}

\item{mod}{Model Matrix with necessary variables the you would model for in
differential expression.}

\item{assayname}{character string specifying the name of the assay desired in rse_tx}
}
\value{
matrix with k principal components for each sample
}
\description{
A wrapper function used to perform qSVA in one step.
}
\examples{
## First we need to define a statistical model. We'll use the example
## rse_tx data. Note that the model you'll use in your own data
## might look different from this model.
mod <- model.matrix(~ mitoRate + Region + rRNA_rate + totalAssignedGene + RIN,
    data = colData(rse_tx)
)

## To ensure that the results are reproducible, you will need to set a
## random seed with the set.seed() function. Internally, we are using
## sva::num.sv() which needs a random seed to ensure reproducibility of the
## results.
set.seed(20230621)
qSVA(rse_tx = rse_tx, mod = mod, assayname = "tpm")

}
