% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{quantroPlot}
\alias{quantroPlot}
\title{Plot results from \code{quantro} function.}
\usage{
quantroPlot(
  object,
  savePlot = FALSE,
  xLab = NULL,
  yLab = NULL,
  mainLab = NULL,
  binWidth = NULL
)
}
\arguments{
\item{object}{a quantro object from \code{quantro}}

\item{savePlot}{a TRUE/FALSE object argument
determining if the plot will be saved for further use or
immediately displayed on the screen.}

\item{xLab}{label for x-axis}

\item{yLab}{label for y-axis}

\item{mainLab}{title of plot}

\item{binWidth}{binwidth or histogram. Default is the stat_bin default.}
}
\value{
A histogram will be plotted containing the null 
test statistics when using boostrapped samples. 
The red line is the observed test statistic
\code{quantroStat} from \code{quantro()}.
}
\description{
This function plots the histogram of the
null test statistics from permutation test in the \code{quantro}
function.
}
\examples{
\donttest{
library(minfi)
data(flowSorted)
p <- getBeta(flowSorted, offset = 100)
pd <- pData(flowSorted)

library(doParallel)
registerDoParallel(cores=4)
qtest <- quantro(p, pd$CellType, B = 100)
quantroPlot(qtest)
}
}
