% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_gtf}
\alias{track_gtf}
\title{Generate gtf track}
\usage{
track_gtf(
  file,
  title = NULL,
  height = 2,
  overlay_previous = "no",
  fontsize = 12,
  orientation = NULL,
  line_width = 0.5,
  color = "#1f78b4",
  border_color = "black",
  prefered_name = "transcript_name",
  merge_transcripts = FALSE,
  labels = FALSE,
  display = "stacked",
  max_labels = 60,
  global_max_row = FALSE,
  gene_rows = NULL,
  arrow_interval = 2,
  arrowhead_included = FALSE,
  color_utr = "grey",
  height_utr = 1,
  arrow_length = NULL,
  all_labels_inside = FALSE,
  labels_in_margin = FALSE
)
}
\arguments{
\item{file}{String. The location of the track file}

\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}

\item{fontsize}{Numeric value to font size of tracks's text.}

\item{orientation}{String. Set to "inverted" to make the track upside down.
Default is NULL.}

\item{line_width}{Numeric. Default is 0.5.}

\item{color}{String. Hex color or string color. Default is "#1f78b4".}

\item{border_color}{String. default is "black"}

\item{prefered_name}{String. Denote which column to get elements names.
Default is "transcript_name".}

\item{merge_transcripts}{Boolean. Default is FALSE.}

\item{labels}{Boolean. Default is FALSE.}

\item{display}{String. options are "stacked" (default) or "collapsed",
"triangles" or "interleaved".}

\item{max_labels}{Numeric. Any integer about 1. Default is 60.}

\item{global_max_row}{Boolean. Default is FALSE.}

\item{gene_rows}{Numeric. Default is NULL.}

\item{arrow_interval}{Numeric. Should be above 1. Default is 2}

\item{arrowhead_included}{Boolean. Default is FALSE}

\item{color_utr}{String. Hex color or string. Default is "grey"}

\item{height_utr}{Numeric. Between 0 and 1. Default is 1.}

\item{arrow_length}{Numeric. Default is NULL.}

\item{all_labels_inside}{Boolean. Default is FALSE}

\item{labels_in_margin}{Boolean. Default is FALSE.}
}
\value{
genome_track
}
\description{
Create genome_track object for gtf annotation files.
}
\details{
gtf files, unlike bed file, can provide richer annotation regarding levels of
annotation where genomic features can be grouped based on the composing entity.
}
\note{
\code{fontsize} argument can be overriden by the same argument in \code{plot_gtracks()}
}
\examples{
gtf_dir <- system.file("extdata", "dm3_subset_BDGP5.78.gtf.gz",
  package = "rGenomeTracks"
)
gtf <- track_gtf(
  file = gtf_dir, height = 10,
  prefered_name = "gene_name", merge_transcripts = TRUE, fontsize = 12
)
\dontrun{
plot_gtracks(gtf + track_spacer() +
  track_x_axis(), chr = "X", start = 30 * 10^5, end = 33 * 10^5)
}
}
\author{
Omar Elashkar
}
