% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_rse.R
\name{filter_clustered_variants}
\alias{filter_clustered_variants}
\title{Filter out clustered sequence variants}
\usage{
filter_clustered_variants(
  rse,
  txdb,
  regions = c("transcript", "genome"),
  variant_dist = 100
)
}
\arguments{
\item{rse}{\code{SummarizedExperiment::SummarizedExperiment} containing editing
sites}

\item{txdb}{\code{GenomicFeatures::TxDb}}

\item{regions}{One of \code{transcript} or \code{genome}, specifying the coordinate
system for calculating distances between variants.}

\item{variant_dist}{distance in nucleotides for determining clustered
variants}
}
\value{
\code{SummarizedExperiment::SummarizedExperiment} with sites removed from
object dependent on filtering applied.
}
\description{
Sequence variants of multiple allele types (e.g., \code{A -> G},
\code{A -> C}) proximal to a putative editing site can be indicative of a region
prone to mis-alignment artifacts. Sites will be removed if variants of
multiple allele types are present within a given distance in genomic or
transcriptome coordinate space.
}
\examples{
if(require("txdbmaker")){
  rse_adar_ifn <- mock_rse()
  rse <- rse_adar_ifn[seqnames(rse_adar_ifn) == "SPCS3"]

  # mock up a txdb with genes
  gr <- GRanges(c(
      "SPCS3:100-120:-",
      "SPCS3:325-350:-"
  ))
  gr$source <- "raer"
  gr$type <- "exon"
  gr$source <- NA
  gr$phase <- NA_integer_
  gr$gene_id <- c(1, 2)
  gr$transcript_id <- c("1.1", "2.1")
  txdb <- txdbmaker::makeTxDbFromGRanges(gr)

  rse <- filter_multiallelic(rse)
  filter_clustered_variants(rse, txdb, variant_dist = 10)

}

}
\seealso{
Other se-filters: 
\code{\link{filter_multiallelic}()},
\code{\link{filter_splice_variants}()}
}
\concept{se-filters}
