% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\name{randorth}
\alias{randorth}
\title{Random orthogonal matrix}
\usage{
randorth(n, type = c("orthonormal", "unitary"), I.matrix = FALSE)
}
\arguments{
\item{n}{\code{numeric} of length 1 defining the dimensions of the \code{n x n} square matrix.}

\item{type}{Either \code{"orthonormal"} or \code{"unitary"} defining whether a real orthonormal matrix or a complex unitary matrix should be returned.}

\item{I.matrix}{If \code{TRUE}, the identity matrix is returned.}
}
\value{
A random orthogonal matrix of dimension \code{n x n}.
}
\description{
Generation of a random orthogonal \code{n x n} matrix.
}
\details{
A random orthogonal matrix \code{R} is generated in order that \code{t(R)} (for \code{"orthonormal"}) or \code{Conj(t(R))} (for \code{"unitary"}) equals the inverse matrix of \code{R}.

This function was adapted from the pracma package (\code{\link[pracma:randortho]{pracma::randortho}}).

The random orthogonal matrices are distributed with Haar measure over
\code{O(n)}, where \code{O(n)} is the set of orthogonal matrices of order \code{n}.
The random orthogonal matrices are basically distributed "uniformly" in the
space of random orthogonal matrices of dimension \code{n x n}.
See also the \code{Examples} and \insertCite{Stewart1980a,Mezzadri2007}{randRotation}.
}
\examples{

# The following example shows the orthogonality of the random orthogonal matrix:
R1 <- randorth(4)
zapsmall(t(R1) \%*\% R1)

R1 <- randorth(4, "unitary")
zapsmall(Conj(t(R1)) \%*\% R1)

# The following example shows the distribution of 2-dimensional random orthogonal vectors
# on the unit circle.
tmp1 <- vapply(1:400, function(i)randorth(2)[,1], numeric(2))
plot(t(tmp1), xlab = "x", ylab = "y")

}
\references{
\insertAllCited{}
}
\author{
Peter Hettegger
}
