% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotCycleLoad}
\alias{plotCycleLoad}
\alias{PlotCycleLoad}
\title{Cycle Load Plot}
\usage{
plotCycleLoad(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
plotting the number of MS2 per MS1 (the duty cycle) scan versus retention
time. The deepskyblue colored loess curve shows the trend.
}
\examples{
rawrr::sampleFilePath() |> rawDiag::readRaw() -> S

S |> rawDiag::plotCycleLoad()
}
\references{
\itemize{
\item rawDiag: \doi{10.1021/acs.jproteome.8b00173},
\item rawrr: \doi{10.1021/acs.jproteome.0c00866}
}
}
\author{
Christian Trachsel (2017), Christian Panse (2023)
}
