% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNumDrugActivityRepeats.R
\name{getNumDrugActivityRepeats}
\alias{getNumDrugActivityRepeats}
\title{Returns a vector indicating the number of drug activity repeat experiments with available data
for each member of a set of compounds.}
\usage{
getNumDrugActivityRepeats(nscSet, onlyCellMinerExps = TRUE)
}
\arguments{
\item{nscSet}{a character vector specifying NSC identifier(s) for compound(s) of interest.}

\item{onlyCellMinerExps}{a logical value indicating whether to return only the number of
experiments with data included in CellMiner (default=TRUE).}
}
\value{
a numeric vector, indexed by nscSet, indicating the number of drug activity 
repeat experiments for each one of its compounds.
}
\description{
Returns a vector indicating the number of drug activity repeat experiments with available data
for each member of a set of compounds.
}
\examples{
nscSet <- c("1", "17", "89", "609699")
getNumDrugActivityRepeats(nscSet)

}
\concept{rcellminer}
