% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellMiner2D.R
\name{plotCellMiner2D}
\alias{plotCellMiner2D}
\title{Make a simple 2d plot using two variables with ggplot2}
\usage{
plotCellMiner2D(
  df,
  xCol = "x",
  yCol = "y",
  xLabel = xCol,
  yLabel = yCol,
  title = NULL,
  colorPalette = NULL,
  classCol = NULL,
  tooltipCol = NULL,
  showLegend = FALSE,
  showTrendLine = TRUE,
  showTitle = TRUE,
  singleColor = "#0000FF",
  alpha = 1,
  numberColPrefix = "X",
  xLimVal = NULL,
  yLimVal = NULL,
  pointSize = 3
)
}
\arguments{
\item{df}{a data.frame with at least two columns}

\item{xCol}{the name of the column in df with the "x" data. See Note}

\item{yCol}{the name of the column in df with the "y" data. See Note}

\item{xLabel}{the x plot label}

\item{yLabel}{the y plot label}

\item{title}{the plot title, if null the correlation will appear (DEFAULT: NULL)}

\item{colorPalette}{a named vector with the names classes and value colors (DEFAULT: NULL)}

\item{classCol}{the name of the column with the classes. Values in column of df must be a factor (DEFAULT: NULL)}

\item{tooltipCol}{the name of the column used for tooltips when plotted with plotly}

\item{showLegend}{boolean, whether to show the legend (DEFAULT: FALSE)}

\item{showTrendLine}{boolean, whether to show the trendline}

\item{showTitle}{boolean, whether to show the title}

\item{singleColor}{a color to be used for all points when a color palette is not provided (DEFAULT: blue)}

\item{alpha}{value from 0-1, where 0 indicates transparent points (DEFAULT: 1, not transparent)}

\item{numberColPrefix}{a prefix to add to column names that start with a number that causes issues with ggplot (DEFAULT: X)}

\item{xLimVal}{a two entry vector (min, max) to set the x-axis}

\item{yLimVal}{a two entry vector (min, max) to set the y-axis}

\item{pointSize}{size of points on plot (DEFAULT: 3)}
}
\value{
a ggplot object
}
\description{
Make a simple 2d plot using two variables with ggplot2
}
\note{
TROUBLESHOOTING NOTES: 1) Avoid ":" in colnames

Uses ggplot aes_string() which uses parse() to turn your text expression into a proper R symbol that can be resolved within the data.frame. Avoid numbers and spaces in
}
\examples{
\dontrun{
# Load data
nci60DrugActZ <- exprs(getAct(rcellminerData::drugData))
nci60GeneExpZ <- getAllFeatureData(rcellminerData::molData)[["exp"]]
# Load colors
colorTab <- loadNciColorSet(returnDf=TRUE)
tissueColorTab <- unique(colorTab[, c("tissues", "colors")])
# Merge data
df <- as.data.frame(t(rbind(nci60DrugActZ["94600",], nci60GeneExpZ["SLFN11",])))
colnames(df) <- c("y", "x")
df <- cbind(df, colorTab)
# Plot data
plotCellMiner2D(df, xCol="x", yCol="y", xLabel="SLFN11", yLabel="94600")
plotCellMiner2D(df, xCol="x", yCol="y", showTrendLine = FALSE, showTitle = FALSE)
plotCellMiner2D(df, xCol="x", yCol="y", showTrendLine = FALSE, showLegend = FALSE)
}

}
\author{
Augustin Luna <augustin AT mail.nih.gov>
}
\concept{rcellminer}
