% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDrugSets.R
\name{plotDrugSets}
\alias{plotDrugSets}
\title{Produces a barplot of the average values for a set of NSCs with a error bar (one standard deviation)}
\usage{
plotDrugSets(
  drugAct,
  drugs,
  mainLabel = "",
  pdfFilename = NULL,
  statistic = "mean"
)
}
\arguments{
\item{drugAct}{a matrix of drug activity values (cell lines as columns, drug entries as rows)}

\item{drugs}{a vector of NSC IDs whose values will be averaged by cell line}

\item{mainLabel}{a main label for the plot}

\item{pdfFilename}{a string file name for a PDF plot, no file output will be produced if this is not provided}

\item{statistic}{a string, either 'mean' or 'median' (Default: mean)}
}
\value{
no values are returned
}
\description{
Produces a barplot of the average values for a set of NSCs with a error bar (one standard deviation)
}
\examples{
drugAct <- exprs(getAct(rcellminerData::drugData))
drugs <- rownames(drugAct)[1:8]
plotDrugSets(drugAct, drugs, "Test")

}
\concept{rcellminer}
