% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_db.R
\name{getdb}
\alias{getdb}
\alias{getdb_h5se_test}
\alias{getdb_h5_test}
\alias{getdb_h5se_gr}
\alias{getdb_h5se_gm}
\alias{getdb_h5se_rg}
\alias{getdb_h5_rg}
\title{Access database files.}
\usage{
getdb_h5se_test(
  platform = NULL,
  dfp = NULL,
  namematch = "remethdb-h5se_gr-test.*",
  verbose = FALSE
)

getdb_h5_test(
  platform = NULL,
  namematch = "remethdb-h5_rg-test_.*",
  dfp = NULL,
  verbose = FALSE
)

getdb_h5se_gr(
  platform = c("hm450k", "epic"),
  dfp = NULL,
  namematch = "remethdb_h5se-gr_.*",
  verbose = FALSE
)

getdb_h5se_gm(
  platform = c("hm450k", "epic"),
  dfp = NULL,
  namematch = "remethdb_h5se-gm_.*",
  verbose = FALSE
)

getdb_h5se_rg(
  platform = c("hm450k", "epic"),
  dfp = NULL,
  namematch = "remethdb-h5se_rg_.*",
  verbose = FALSE
)

getdb_h5_rg(
  platform = c("hm450k", "epic"),
  dfp = NULL,
  namematch = "remethdb-h5_rg_.*",
  verbose = FALSE
)
}
\arguments{
\item{platform}{Valid supported DNAm array platform type. Currently either
"epic" for EPIC/HM850K, or "hm450k" for HM450K.}

\item{dfp}{Folder to search for database file 
(optional, if NULL then searches cache dir specified by BiocFileCache).}

\item{namematch}{Filename pattern to match when searching for database 
(see defaults).}

\item{verbose}{Whether to return verbose messages (default FALSE).}
}
\value{
Either a SummarizedExperiment object for h5se functions, or a file 
path for h5 functions.
}
\description{
Combines download and load functions for databases. 
If the "namematch" argument isn't provided, the latest available 
file is downloaded. All files include metadata for the available samples.

There are 6 functions. Functions with "h5se" access 
HDF5-SummarizedExperiment files, and "h5" functions access HDF5 databases. 
The 4 h5se functions are "rg" (RGChannelSet), "gm" (MethylSet), "gr" 
(GenomicRatioSet), and "test" (data for 2 samples from "gr"). The 2 h5 
functions are "rg" (red and green signal datasets), and "test" (data for 2 
samples from "rg"). See vignette for details about file types and classes.
}
\examples{
\donttest{
h5 <- getdb_h5_test(dfp = tempdir())
}
}
\seealso{
get_rmdl()
}
