% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapGraphicalSummary.R
\name{overlapGraphicalSummary}
\alias{overlapGraphicalSummary}
\title{Overlap Graphical Summary}
\usage{
overlapGraphicalSummary(A, B, regions.labels=c("A","B"), regions.colors=c("black","forestgreen","darkred"), ...)
}
\arguments{
\item{A}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{B}{a region set in any of the accepted formats by \code{\link{toGRanges}} (\code{\link{GenomicRanges}}, \code{\link{data.frame}}, etc...)}

\item{regions.labels}{vector indicating the labels for the y axes.}

\item{regions.colors}{character vector indicating the colors for the regions.}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}). 

 @return A plot is created on the current graphics device.}
}
\description{
Graphical summary of the overlap between two set of regions.
}
\examples{
A <- data.frame(chr=1, start=c(1,15,24,40,50), end=c(10,20,30,45,55))

B <- data.frame(chr=1, start=c(2,12,28,35), end=c(5,25,33,43))

overlapGraphicalSummary(A, B, regions.labels=c("A","B"), regions.colors=c(4,5,6))

}
\seealso{
\code{\link{overlapPermTest}}, \code{\link{overlapRegions}}
}
