% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.permTestResults.R
\name{plot.permTestResults}
\alias{plot.permTestResults}
\title{Function for plotting the results from a \code{permTestResults} object.}
\usage{
\method{plot}{permTestResults}(
  x,
  pvalthres = 0.05,
  plotType = "Tailed",
  main = "",
  xlab = NULL,
  ylab = "",
  ylim = NULL,
  xlim = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{permTestResults}.}

\item{pvalthres}{p-value threshold for significance. Default is 0.05.}

\item{plotType}{the type of plot to display. This must be one of \code{"Area"} or \code{"Tailed"}. Default is \code{"Area"}.}

\item{main}{a character specifying the title of the plot. Defaults to "".}

\item{xlab}{a character specifying the label of the x axis. Defaults to NULL, which produces a plot with the evaluation function name as the x axis label.}

\item{ylab}{a character specifying the label of the y axis. Defaults to "".}

\item{ylim}{defines the y limits of the plot. Passed to the underlying \code{plot} call.}

\item{xlim}{defines the x limits of the plot. Passed to the underlying \code{plot} call.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A plot is created on the current graphics device.
}
\description{
Function for plotting the results from a \code{permTestResults} object.
}
\examples{

genome <- filterChromosomes(getGenome("hg19"), keep.chr="chr1")
A <- createRandomRegions(nregions=20, length.mean=10000000, length.sd=20000, genome=genome, non.overlapping=FALSE) 
B <- c(A, createRandomRegions(nregions=10, length.mean=10000, length.sd=20000, genome=genome, non.overlapping=FALSE))

pt <- overlapPermTest(A=A, B=B, ntimes=10, genome=genome, non.overlapping=FALSE)
summary(pt)
plot(pt)
plot(pt, plotType="Tailed")  
 
pt2 <- permTest(A=A, B=B, ntimes=10, alternative="auto", genome=genome, evaluate.function=meanDistance, randomize.function=randomizeRegions, non.overlapping=FALSE)
summary(pt2)
plot(pt2)
plot(pt2, plotType="Tailed")

}
\seealso{
\code{\link{permTest}}
}
