% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSinglePT.R
\name{plotSinglePT}
\alias{plotSinglePT}
\title{plotSinglePT}
\usage{
plotSinglePT(mPT, RS1, RS2, xlab = NA, main = NA)
}
\arguments{
\item{mPT}{an object of class \link[=genoMatriXeR-class]{genoMatriXeR}.}

\item{RS1, RS2}{character, names of region sets in a genoMatriXeR object for which to represent the pairwise permutation test results.}

\item{xlab}{character, label for x axis. (default = NA)}

\item{main}{title for the plot, if NA the name of the genoMatriXeR object is used (default = NA)}
}
\value{
Returns a ggplot object.
}
\description{
Plot the result of a single pairwise permutation test from a genoMatriXeR object.
}
\details{
This function generates a plot representing the result of a single
permutation test stored in a \link[=genoMatriXeR-class]{genoMatriXeR} object. This includes a plot of the
density distribution of the randomized evaluations and a vertical line
showing the observed evaluation in the original region set. The values of the
mean randomized evaluations and the value of the observed evaluation are
shown, in addition to the calculated Z-score, normalized Z-score and adjusted
p-value.
}
\examples{

data("cw_Alien")
plotSinglePT(cw_Alien_ReG, RS1 = "regA", RS2 = "regA_05")
plotSinglePT(cw_Alien_ReG, RS1 = "regA", RS2 = "regC")

}
\seealso{
\link{crosswisePermTest} \link{makeCrosswiseMatrix}
}
