% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgoslin.R
\name{parseLipidNames}
\alias{parseLipidNames}
\title{Parse multiple lipid names and return a data frame with the results.}
\usage{
parseLipidNames(lipidNames, grammar = NULL)
}
\arguments{
\item{lipidNames}{The vector of lipid names to parse.}

\item{grammar}{The grammar to use. One of "Goslin", "GoslinFragments",
"SwissLipids", "LipidMaps", "HMDB", "FattyAcids". Call
\code{listAvailableGrammars()} for a complete list of available grammars.
If \code{grammar} is omitted or \code{NULL} is passed as a parameter, all
available grammars / parsers will be tested. The first successful one will
win. If all parsers fail, the "Messages" column in the returned data frame
will contain the last parsers message.}
}
\value{
Data frame where each row reports the parsing result of each element
in lipidNames.
}
\description{
\code{parseLipidNames} reads the provided lipid names vector and returns
structural information as a data frame. Will return a cell with the
"Grammar" column set to "NOT_PARSEABLE" if none of the parsers was able to
parse the provided name successfully. Will stop execution via \code{stop} if 
invalid non character input is detected or fatal errors are encountered 
during parsing.
}
\examples{
parseLipidNames(c("PC 32:1","LPC 34:1","TG(18:1_18:0_16:1)"))
parseLipidNames(c("Cer(d18:1(8Z)/24:0)", grammar = "LipidMaps"))
}
