% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5O.R
\name{H5Oget_info}
\alias{H5Oget_info}
\title{Retrieves the metadata for an HDF5 object specified by an identifier.}
\usage{
H5Oget_info(h5loc)
}
\arguments{
\item{h5loc}{An object of class \linkS4class{H5IdComponent} representing an open
HDF5 dataset or group.}
}
\description{
Retrieves the metadata for an HDF5 object specified by an identifier.
}
\examples{

## Create a temporary copy of an example file check the contents
example_file <- system.file("testfiles", "h5ex_t_array.h5", package = "rhdf5")

## open the example file, root group, and DS1 dataset
fid <- H5Fopen(example_file)
gid <- H5Gopen(fid, "/")
did <- H5Dopen(fid, "/DS1")

## List the available object information for both groups and datasets
H5Oget_info(h5loc = gid)

H5Oget_info(h5loc = did)

## close open handles
h5closeAll(did, gid, fid)

}
