% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5O.R
\name{H5Olink}
\alias{H5Olink}
\title{Create a hard link to an object in an HDF5 file}
\usage{
H5Olink(h5obj, h5loc, newLinkName, lcpl = NULL, lapl = NULL)
}
\arguments{
\item{h5obj}{An object of class \linkS4class{H5IdComponent} representing the object to be linked to.}

\item{h5loc}{An object of class \linkS4class{H5IdComponent} representing the location at which the
object is to be linked.  Can represent a file, group, dataset, datatype or attribute.}

\item{newLinkName}{Character string giving the name of the new link.  This should be relative to
\code{h5loc}.}

\item{lcpl, lapl}{\linkS4class{H5IdComponent} objects representing link creation and link access property lists
respectively.  If left as \code{NULL} the default values for these will be used.}
}
\description{
Create a hard link to an object in an HDF5 file
}
\examples{
## Create a temporary copy of an example file, and open it
example_file <- system.file("testfiles", "h5ex_t_array.h5", package = "rhdf5")
file.copy(example_file, tempdir())
h5_file <- file.path(tempdir(), "h5ex_t_array.h5")
fid <- H5Fopen(h5_file)

## create a new group without a location in the file
gid <- H5Gcreate_anon(fid)

## create link to newly create group
## relative to the file identifier
H5Olink(h5obj = gid, h5loc = fid, newLinkName = "foo")

## tidy up
H5Gclose(gid)
H5Fclose(fid)

## Check we now have a "/foo" group
h5ls(h5_file)

}
\seealso{
\link{H5Gcreate_anon}
}
