% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5.R
\name{h5closeAll}
\alias{h5closeAll}
\title{Close open HDF5 handles}
\usage{
h5closeAll(...)
}
\arguments{
\item{...}{One or more objects of class \linkS4class{H5IdComponent} which should be
closed.  If nothing is provided to the function, all open handles will be
closed.}
}
\value{
Doesn't return anything. Called for the side-effect of closing open
HDF5 handles.
}
\description{
This functions can be used in two ways.  Firstly, it can be passed one or
more \linkS4class{H5IdComponent} objects and it'll will try to close all of them
regardless of the whether they represent a file, group, dataset etc.  This
can be easier than making multiple calls to \code{\link[=H5Fclose]{H5Fclose()}}, \code{\link[=H5Gclose]{H5Gclose()}}, etc.
}
\details{
Secondly, occasionally references to HDF5 files, groups, datasets etc can be
created and not closed correctly.  Maybe because a function stopped before
getting to the close statement, or the open handle was not assigned to an R
variable.  If no arguments are provide this function identifies all open
handles and closes them.
}
\examples{


## create an empty file and then re-open it
h5File <- tempfile(pattern = "ex_h5closeAll.h5")
h5createFile(h5File)
H5Fopen(h5File)

## list all open identifiers
h5listIdentifier()

## close all open identifiers and verify
h5closeAll()
h5listIdentifier()

}
\author{
Mike Smith
}
\keyword{IO}
\keyword{file}
