% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5readTimestamps.R
\name{h5readTimestamps}
\alias{h5readTimestamps}
\title{Read the time stamps associated with an HDF5 group or dataset.}
\usage{
h5readTimestamps(file, name)
}
\arguments{
\item{file}{Character vector of length 1, giving the path to the HDF5 file}

\item{name}{Path within the HDF5 file to the object whose attributes should
be read. The datasets present in \code{file} can be listed with the
function \code{\link{h5ls}}.}
}
\value{
A named list of length 4 containing the timestamps on the object.
The timestamps themselves are \code{POSIXct} objects (see
\code{\link[base:DateTimeClasses]{base::DateTimeClasses()}}).
}
\description{
Read the time stamps associated with an HDF5 group or dataset.
}
\details{
All timestamps are returned in the UTC timezone.  HDF5 objects
can have between 0 and 4 timestamps set, depending on the property lists
provided when they are created or accessed.  Timestamps that are not tracked
will be returned as the UNIX epoch \verb{1970-01-01 UTC}.
}
\examples{
# example file
example_file <- system.file("testfiles", "h5ex_t_array.h5", package = "rhdf5")

## read timestamps on a group
h5readTimestamps(example_file, name = "/")

## read timestamps on a datasets
h5readTimestamps(example_file, name = "/DS1")

}
