% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterCDS.R
\name{filterCDS}
\alias{filterCDS}
\title{Filter CDS by size}
\usage{
filterCDS(CDS, sizeCutoff = 100L)
}
\arguments{
\item{CDS}{Output of preparedCDS}

\item{sizeCutoff}{numeric(1). Cutoff size for CDS.
If the size of CDS is less than the cutoff, it will be filtered out.}
}
\value{
A GRanges object with filtered CDS.
}
\description{
Filter CDS by CDS size.
}
\examples{
#library(txdbmaker)
library(BSgenome.Drerio.UCSC.danRer10)
#txdb <- makeTxDbFromGFF(system.file("extdata",
 #         "Danio_rerio.GRCz10.91.chr1.gtf.gz",
 #         package="ribosomeProfilingQC"),
 #         organism = "Danio rerio",
 #         chrominfo = seqinfo(Drerio)["chr1"],
 #         taxonomyId = 7955)
#CDS <- prepareCDS(txdb)
CDS <- readRDS(system.file("extdata", "CDS.rds",
                           package="ribosomeProfilingQC"))
filterCDS(CDS)
}
