% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeTEbyLoess.R
\name{normalizeTEbyLoess}
\alias{normalizeTEbyLoess}
\title{Normalize the TE by Loess}
\usage{
normalizeTEbyLoess(
  TE,
  log2 = TRUE,
  pseudocount = 0.001,
  span = 2/3,
  family.loess = "symmetric"
)
}
\arguments{
\item{TE}{output of \link{translationalEfficiency}.}

\item{log2}{logical(1L). Do log2 transform for TE or not. If TE value is not
log2 transformed, please set it as TRUE.}

\item{pseudocount}{The number will be add to sum of reads count to avoid X/0.}

\item{span, family.loess}{Parameters will be passed to \link[stats]{loess}}
}
\value{
A list with RPFs, mRNA levels and TE as a matrix with
log2 transformed translational efficiency.
}
\description{
Fitting the translational efficiency values with the mRNA value by \link[stats]{loess}.
}
\examples{
path <- system.file("extdata", package="ribosomeProfilingQC")
cnts <- readRDS(file.path(path, "cnts.rds"))
fpkm <- getFPKM(cnts)
te <- translationalEfficiency(fpkm)
te1 <- normalizeTEbyLoess(te)
plotTE(te)
plotTE(te1, log2=FALSE)
}
