% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistance2Codon.R
\name{plotDistance2Codon}
\alias{plotDistance2Codon}
\title{Metaplot of P site distribution}
\usage{
plotDistance2Codon(
  reads,
  start = TRUE,
  anchor = 50,
  col = c(Frame_0 = "#009E73", Frame_1 = "#D55E00", Frame_2 = "#0072B2")
)
}
\arguments{
\item{reads}{Output of \link{assignReadingFrame}.}

\item{start}{Plot for start codon or stop codon.}

\item{anchor}{The maximal xlim or (min, max) position for plot.}

\item{col}{Colors for different reading frame.}
}
\value{
Invisible height of the barplot.
}
\description{
Metaplot of P site distribution in all the CDS aligned by
the start codon or stop codon.
}
\examples{
pcs <- readRDS(system.file("extdata", "samplePc.rds",
               package="ribosomeProfilingQC"))
plotDistance2Codon(pcs)
#plotDistance2Codon(pcs, start=FALSE)
#plotDistance2Codon(pcs, anchor=c(-10, 20))
}
