% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readsDistribution.R
\name{readsDistribution}
\alias{readsDistribution}
\title{Plot reads distribution in genomic elements}
\usage{
readsDistribution(
  reads,
  txdb,
  upstreamRegion = 3000,
  downstreamRegion = 3000,
  plot = TRUE,
  precedence = NULL,
  ignore.seqlevelsStyle = FALSE,
  ...
)
}
\arguments{
\item{reads}{Output of \link{getPsiteCoordinates}}

\item{txdb}{A TxDb object}

\item{upstreamRegion, downstreamRegion}{The range for promoter region and
downstream region.}

\item{plot}{Plot the distribution or not}

\item{precedence}{If no precedence specified, double count will be enabled,
which means that if the reads overlap with both CDS and 5'UTR, both
CDS and 5'UTR will be incremented. If a precedence order is specified,
for example, if promoter is specified before 5'UTR, then only promoter will
be incremented for the same example.  The values could be any combinations
of "CDS", "UTR5", "UTR3", "OtherExon", "Intron", "upstream", "downstreama"
and "InterGenic", Default=NULL}

\item{ignore.seqlevelsStyle}{Ignore the sequence name style detection or not.}

\item{...}{Not use.}
}
\value{
The reads with distribution assignment
}
\description{
Plot the percentage of reads in CDS, 5'UTR, 3'UTR, introns, and
 other elements.
}
\examples{
library(Rsamtools)
bamfilename <- system.file("extdata", "RPF.WT.1.bam",
                           package="ribosomeProfilingQC")
yieldSize <- 10000000
bamfile <- BamFile(bamfilename, yieldSize = yieldSize)
pc <- getPsiteCoordinates(bamfile, bestpsite=11)
pc.sub <- pc[pc$qwidth \%in\% c(29, 30)]
library(txdbmaker)
library(BSgenome.Drerio.UCSC.danRer10)
txdb <- makeTxDbFromGFF(system.file("extdata",
          "Danio_rerio.GRCz10.91.chr1.gtf.gz",
          package="ribosomeProfilingQC"),
          organism = "Danio rerio",
          chrominfo = seqinfo(Drerio)["chr1"],
          taxonomyId = 7955)
pc.sub <- readsDistribution(pc.sub, txdb, las=2)
pc.sub <- readsDistribution(pc[pc$qwidth \%in\% c(29, 30)],
              txdb, las=2,
              precedence=c(
              "CDS", "UTR5", "UTR3", "OtherExon",
              "Intron", "upstream", "downstream",
              "InterGenic"
              ))
}
