% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ribosomeReleaseScore.R
\name{ribosomeReleaseScore}
\alias{ribosomeReleaseScore}
\title{Ribosome Release Score (RRS)}
\usage{
ribosomeReleaseScore(
  cdsTE,
  utr3TE,
  CDSsampleOrder,
  UTR3sampleOrder,
  pseudocount = 0,
  log2 = FALSE
)
}
\arguments{
\item{cdsTE, utr3TE}{Translational efficiency of CDS and UTR3 region.
Output of \link{translationalEfficiency}}

\item{CDSsampleOrder, UTR3sampleOrder}{Sample order of cdsTE and utr3TE.
The parameters are used to make sure that the order of CDS and UTR3 in TE
 is corresponding samples.}

\item{pseudocount}{The number will be add to sum of reads count to avoid X/0.}

\item{log2}{Do log2 transform or not.}
}
\value{
A vector of RRS.
}
\description{
RRS is calculated as the ratio of translational efficiency in
 the CDS with RPFs in the 3'UTR.
}
\examples{

\dontrun{
path <- system.file("extdata", package="ribosomeProfilingQC")
RPFs <- dir(path, "RPF.*?\\\\.[12].bam$", full.names=TRUE)
RNAs <- dir(path, "mRNA.*?\\\\.[12].bam$", full.names=TRUE)
gtf <- file.path(path, "Danio_rerio.GRCz10.91.chr1.gtf.gz")
cvgs <- coverageDepth(RPFs, RNAs, gtf)
cvgs.utr3 <- coverageDepth(RPFs, RNAs, gtf, region="utr3")
TE90 <- translationalEfficiency(cvgs, window = 90)
TE90.utr3 <- translationalEfficiency(cvgs.utr3, window = 90)
rrs <- ribosomeReleaseScore(TE90, TE90.utr3)
}

}
