% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftReadsByFrame.R
\name{shiftReadsByFrame}
\alias{shiftReadsByFrame}
\title{Shift reads by reading frame}
\usage{
shiftReadsByFrame(reads, txdb, ignore.seqlevelsStyle = FALSE)
}
\arguments{
\item{reads}{Output of \link{getPsiteCoordinates}}

\item{txdb}{A TxDb object.}

\item{ignore.seqlevelsStyle}{Ignore the sequence name style detection or not.}
}
\value{
Reads with reading frame information
}
\description{
Shift reads P site position by reading frame. After shifting,
all reading frame will be set as 0
}
\examples{
library(Rsamtools)
bamfilename <- system.file("extdata", "RPF.WT.1.bam",
                           package="ribosomeProfilingQC")
yieldSize <- 10000000
bamfile <- BamFile(bamfilename, yieldSize = yieldSize)
pc <- getPsiteCoordinates(bamfile, bestpsite=11)
pc.sub <- pc[pc$qwidth \%in\% c(29, 30)]
library(txdbmaker)
library(BSgenome.Drerio.UCSC.danRer10)
txdb <- makeTxDbFromGFF(system.file("extdata",
          "Danio_rerio.GRCz10.91.chr1.gtf.gz",
          package="ribosomeProfilingQC"),
          organism = "Danio rerio",
          chrominfo = seqinfo(Drerio)["chr1"],
          taxonomyId = 7955)
pc.sub <- shiftReadsByFrame(pc.sub, txdb)

}
