% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding_TI.r
\name{finding_TI}
\alias{finding_TI}
\title{\subsection{=========================================================================
finding_TI}{

finding_TI flags potential candidates for transcription interference
}}
\usage{
finding_TI(inp, cores, pen = 10, thrsh = 0.5, add = 1000)
}
\arguments{
\item{inp}{SummarizedExperiment: the input.}

\item{cores}{integer: the number of assigned cores for the task}

\item{pen}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Advised to be kept at 10.
Default is 10.}

\item{thrsh}{numeric: an internal parameter that allows fragments with a
certain amount of IDs with higher relative intensities at time points later
than "0" to be flagged as "\emph{TI}". Higher values result in fewer candidates.
-0.5 is 25 \%, 0 is 50\%, 0.5 is 75\%. Advised to be kept at 0.5.
Default is 0.5.}

\item{add}{integer: range of nucleotides before and after a potential TI
event wherein IDs are fitted with the TI fit.}
}
\value{
The SummarizedExperiment object: with "\emph{TI}" added to the flag
column.
}
\description{
finding_TI uses 'score_fun_ave' to make groups by the mean of "probe_TI".
"TI" is added to the "flag" column. TI is characterized by relative
intensities at time points later than "0". The rowRanges need to contain at
least "ID", "probe_TI" and "position_segment"!
}
\examples{
data(preprocess_minimal)
finding_TI(inp = preprocess_minimal, cores = 2, pen = 10, thrsh = 0.5,
add = 1000)

}
