% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rifi_preprocess.r
\name{rifi_preprocess}
\alias{rifi_preprocess}
\title{\subsection{=========================================================================
rifi_preprocess}{

rifi_preprocess wraps conveniently all pre-processing steps
}}
\usage{
rifi_preprocess(
  inp,
  cores,
  FUN_filter = function(x) {     FALSE },
  bg = 0,
  rm_FLT = FALSE,
  thrsh_check = 0,
  dista = 300,
  run_PDD = FALSE,
  pen_PDD = 2,
  pen_out_PDD = 1,
  thrsh_PDD = 0.001,
  pen_TI = 10,
  thrsh_TI = 0.5,
  add = 1000
)
}
\arguments{
\item{inp}{SummarizedExperiment: the input.}

\item{cores}{integer: the number of assigned cores for the task.}

\item{FUN_filter}{function: A function of x, returning a logical.
x is the numeric vector of the intensity from all time points for a specific
replicate.}

\item{bg}{numeric: threshold over which the last time point has to be to be
fitted with the above background mode.}

\item{rm_FLT}{logical: remove IDs where all replicates are marked as filtered
by the background check. Default is FALSE.}

\item{thrsh_check}{numeric: the minimal allowed intensity for time point "0".
Advised to be kept at 0! Default is 0.}

\item{dista}{integer: the amount of nucleotides defining the gap. Default is
300.}

\item{run_PDD}{logical: running the PDD flag function}

\item{pen_PDD}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Advised to be kept at 2. Default
is 2.}

\item{pen_out_PDD}{numeric: an internal parameter for the dynamic
programming. Higher values result in fewer possible outliers. Advised to
be kept at 1. Default is 1.}

\item{thrsh_PDD}{numeric: an internal parameter that allows fragments with
slopes steeper than the threshold to be flagged with "\emph{PDD}". Higher values
result in fewer candidates . Advised to be kept at 0.001. Default is 0.001.}

\item{pen_TI}{numeric: an internal parameter for the dynamic programming.
Higher values result in fewer fragments. Advised to be kept at 10. Default
is 10.}

\item{thrsh_TI}{numeric: an internal parameter that allows fragments with a
certain amount of IDs with higher relative intensities at time points later
than "0" to be flagged as "\emph{TI}". Higher values result in fewer candidates.
-0.5 is 25 \%, 0 is 50\%, 0.5 is 75\%. Advised to be kept at 0.5. Default
is 0.5.}

\item{add}{integer: range of nucleotides before a potential TI event where
in IDs are fitted with the TI fit.}
}
\value{
The SummarizedExperiment object: checked, and with position, ID,
intensity, probe_TI, position_segment, flag and filtration added to the
rowRanges.
}
\description{
rifi_preprocess wraps the functions:
\enumerate{
\item check_input
\item make_df
\item function_seg
\item finding_PDD
\item finding_TI
}
}
\details{
rifi_preprocess allows for the optional integration of filter functions.
Filter functions mark replicates with TRUE. Those are then not considered
in the fit!
FUN_filter is a general filter usually to exclude probes with low
expression or "bad" patterns.
}
\examples{
data(example_input_minimal)
rifi_preprocess(
  inp = example_input_minimal, cores = 2, bg = 100, rm_FLT = FALSE,
  thrsh_check = 0, dista = 300, run_PDD = FALSE
  )
     
}
\seealso{
\code{check_input}

\code{make_df}

\code{segment_pos}

\code{finding_PDD}

\code{finding_TI}
}
