% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_CountSamplesPerGroup.R
\name{CountSamplesPerGroup}
\alias{CountSamplesPerGroup}
\title{Find minimum sample Size per group.}
\usage{
CountSamplesPerGroup(pheno_df, responses_char, covariates_char)
}
\arguments{
\item{pheno_df}{A data frame with phenotype and covariates, which should
include all the samples in \code{rnaEdit_df}. Please make sure the input
\code{pheno_df} has the variable named \code{"sample"} to indicate sample
IDs.}

\item{responses_char}{A character vector of names of response variables in
\code{pheno_df}. When respType is set as \code{"survival"},
\code{responses_char} should have length 2. The first element must be the
name of the variable with follow up time, and the second element must be
the status indicator. Status indicator should be coded as 0/1(1=death),
TRUE/FALSE(TRUE=death), or 1/2(2=death). Please make sure variable names 
are in this order. This code has not been tested for interval-censored 
data yet.}

\item{covariates_char}{A character vector of names of covariate variables in
\code{pheno_df}.}
}
\value{
An integer.
}
\description{
Find minimum sample size for each group which is decided by the
  combination of variables with class character or factor.
}
\examples{
  exm_pheno <- readRDS(
    system.file(
    "extdata",
    "pheno_df.RDS",
    package = 'rnaEditr',
    mustWork = TRUE
    )
  )
  
  CountSamplesPerGroup(
    pheno_df = exm_pheno,
    responses_char = "sample_type",
    covariates_char = "race"
  )

}
\keyword{internal}
