% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_CreateRdrop.R
\name{CreateRdrop}
\alias{CreateRdrop}
\title{Calculates R-drop values for RNA editing sites.}
\usage{
CreateRdrop(
  data,
  method = c("spearman", "pearson"),
  minEditFreq = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data frame of RNA editing level values on individual sites,
with row names as sample IDs and column names as site IDs in the form of
"chrAA:XXXXXXXX".}

\item{method}{Method for computing correlation. Defaults to 
\code{"spearman"}.}

\item{minEditFreq}{Threshold for minimum percentage of edited samples 
for a given 
 site. The \code{r_drop} value of the sites with frequency lower than 
 \code{minEditFreq} will be set as NA. Please set a number between 0 and 1. 
 Defaults to 0.05.}

\item{verbose}{Should messages and warnings be displayed? Defaults to TRUE.}
}
\value{
A data frame with the following columns:
  \itemize{
    \item{\code{site} : }{site ID.}
    \item{\code{r_drop} : }{the correlation between RNA editing levels of 
    one site and the mean RNA editing levels of the rest of the sites.}
  }
}
\description{
Calculates the correlation coefficient between RNA editing 
  levels of one site and the mean RNA editing levels of the rest of the 
  sites in a region.
}
\examples{
  data(t_rnaedit_df)
  
  ordered_cols <- OrderSitesByLocation(
    sites_char = colnames(t_rnaedit_df),
    output = "vector"
  )
  exm_data <- t_rnaedit_df[, ordered_cols]
  
  CreateRdrop(
    data = exm_data,
    method = "spearman"
  )
   
}
\keyword{internal}
