% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestSingleRegion.R
\name{TestSingleRegion}
\alias{TestSingleRegion}
\title{Test associations between phenotype and RNA editing levels.}
\usage{
TestSingleRegion(
  rnaEdit_num,
  modelPrep_ls,
  respType = c("binary", "continuous", "survival")
)
}
\arguments{
\item{rnaEdit_num}{A named numeric vector of (summarized) RNA editing level
values with sample IDs as names.}

\item{modelPrep_ls}{A list includes \code{modelFormula_char} which is 
created by function \code{\link{MakeModelFormula}}, \code{pheno_df} which 
is the input phenotype data frame in \code{\link{TestAssociations}}, and
\code{minSize} (minimum sample size per group to use regular logistic 
regression) which is created by function
\code{\link{CountSamplesPerGroup}} when \code{respType} is \code{"binary"}.}

\item{respType}{Type of outcome. Defaults to \code{"binary"}.}
}
\value{
a dataframe with test statistics (\code{estimate, stdErr, pValue} or
  \code{coef, exp_coef, se_coef, pValue}).
}
\description{
Test associations between phenotype and
  RNA editing levels in a single site or summarized RNA editing levels
  in a single region.
}
\details{
\code{minSize} is used by function \code{TestSingleRegion} to 
  decide on whether to use regular logistic regression or Firth corrected 
  logistic regression (\url{"https://www.jstor.org/stable/2336755"}).
}
\examples{
  data(rnaedit_df)
  
  exm_pheno <- readRDS(
    system.file(
    "extdata",
    "pheno_df.RDS",
    package = 'rnaEditr',
    mustWork = TRUE
    )
  )
  
  exm_model <- list(
    modelFormula_char = "age_at_diagnosis ~ rnaEditSummary",
    pheno_df = exm_pheno,
    minSize = NULL
  )
  
  TestSingleRegion(
    rnaEdit_num = unlist(rnaedit_df[2,]),
    modelPrep_ls = exm_model,
    respType = "continuous"
  )

}
\keyword{internal}
