% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransformToGR.R
\name{TransformToGR}
\alias{TransformToGR}
\title{Transform gene symbols or region ranges into GRanges object.}
\usage{
TransformToGR(
  genes_char,
  type = c("symbol", "region"),
  genome = c("hg38", "hg19")
)
}
\arguments{
\item{genes_char}{A character vector of gene symbols or region ranges. If 
you select \code{type} to be \code{"symbol"}, then please make sure your 
input of \code{genes_char} is in the format of c("ABCB10", "PEX26"). If 
you select \code{type} to be \code{"region"}, then please make sure your 
input of \code{genes_char} is in the format of
c("chr1:33772367-33791699", "chr22:18555686-18573797").}

\item{type}{What is the type of \code{genes_char}. Can be \code{"symbol"} 
(default) or \code{"region"}.}

\item{genome}{Use \code{"hg19"} or \code{"hg38"} gene reference. Defaults 
to \code{"hg38"}. It's only used when \code{type} is set to 
\code{"symbol"}}
}
\value{
A GRanges object with \code{seqnames}, \code{ranges} and
  \code{strand}.
}
\description{
Transform a character vector of gene symbols or region ranges
  into a GRanges object.
}
\details{
\code{TransformToGR()} uses the hg19/hg38 genes to associate gene 
  symbols with their genomic region ranges. The pre-processed dataset is 
  saved in inst/extdata in this package.
  
  Users who wish to add gene symbols to the GRanges created using
  function \code{TransformToGR()} can use function \code{AddMetaData()}. 
  Please see \code{\link{AddMetaData}} for details.
}
\examples{
  TransformToGR(
    genes_char = c("PHACTR4", "CCR5", "METTL7A"),
    type = "symbol",
    genome = "hg19"
  )
  
  TransformToGR(
    genes_char = c("chr22:18555686-18573797", "chr22:36883233-36908148"),
    type = "region",
    genome = "hg19"
  )
 
}
\seealso{
\code{\link{AllCloseByRegions}}, \code{\link{AllCoeditedRegions}}, 
  \code{\link{CreateEditingTable}}, \code{\link{SummarizeAllRegions}}, 
  \code{\link{TestAssociations}}, \code{\link{AnnotateResults}}
}
