% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/opls-methods.R
\name{getEset}
\alias{getEset}
\alias{getEset,}
\alias{opls-method}
\alias{getEset,opls-method}
\title{getEset method}
\usage{
getEset(object)

\S4method{getEset}{opls}(object)
}
\arguments{
\item{object}{An S4 object of class \code{opls}, created by \code{opls}
function.}
}
\value{
An S4 object of class \code{ExpressionSet} which contains the dataMatrix (t(exprs(eset))),
and the sampleMetadata (pData(eset)) and variableMetadata (fData(eset)) with the additional columns
containing the scores, predictions, loadings, VIP, coefficients etc.
}
\description{
Extracts the complemented ExpressionSet when opls has been applied to an ExpressionSet
}
\examples{

data(sacurine)
sacSet <- sacurine[["eset"]]
sacPlsda <- opls(sacSet, "gender")
sacSet <- getEset(sacPlsda)
head(Biobase::pData(sacSet))
head(Biobase::fData(sacSet))

}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
