% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_middle_nodes}
\alias{get_middle_nodes}
\title{Obtain the middle nodes of a path}
\usage{
get_middle_nodes(graph, object, collapse = TRUE)
}
\arguments{
\item{graph}{The SemMed graph}

\item{object}{A vertex sequence (\code{igraph.vs}), a list of vertex
sequences, or a list of vertex sequence lists}

\item{collapse}{If \code{TRUE}, middle node names for different 
source-target pairs are combined into one character 
vector.}
}
\value{
A \code{tbl} where each row corresponds to a source-target pair 
in \code{object}. The last column is a list-column containing character 
vectors of names of middle nodes.
}
\description{
For each pair of source and target nodes in \code{object}, obtain the 
names of middle nodes on paths.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, "Serum cortisol")
node_stress <- find_nodes(g_mini, "Chronic Stress")
paths <- find_paths(g_mini, from = node_cortisol, to = node_stress)
middle <- get_middle_nodes(g_mini, paths)

}
