% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{text_path}
\alias{text_path}
\title{Display path (text form)}
\usage{
text_path(graph, path, print = TRUE)
}
\arguments{
\item{graph}{The SemMed graph}

\item{path}{A vertex sequence (\code{igraph.vs}) (the path to display)}

\item{print}{Print the path to screen?}
}
\value{
Invisibly returns a list of predications for each pair
of nodes along the path.
}
\description{
Show a text display of a path and obtain output that can
be used to explore predications along the path. (A predication 
is a SUBJECT--LINKING VERB-->OBJECT triple.)
}
\details{
\code{text_path} invisibly returns a list of \code{tbl}'s containing
information on the predications on the path. Each list element is a 
\code{tbl} that corresponds to a (sequential) pair of nodes along 
the path. The \code{tbl} contains information on the subject and 
object node's name and semantic type as well as all predicates linking 
the subject and object.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, names = "Serum cortisol")
node_stress <- find_nodes(g_mini, names = "Chronic Stress")
paths <- find_paths(g_mini, from = node_cortisol, to = node_stress)
text_path(g_mini, paths[[1]][[1]])
result <- text_path(g_mini, paths[[1]][[1]], print = FALSE)

}
\seealso{
\code{\link{plot_path}} for plotting paths
}
