% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethodSangerRead.R
\name{SangerRead-class-MakeBaseCalls}
\alias{SangerRead-class-MakeBaseCalls}
\alias{MakeBaseCalls,SangerRead-method}
\title{MakeBaseCalls}
\usage{
\S4method{MakeBaseCalls}{SangerRead}(object, signalRatioCutoff = 0.33)
}
\arguments{
\item{object}{A SangerRead S4 instance.}

\item{signalRatioCutoff}{The ratio of the height of a secondary peak to a primary peak. Secondary peaks higher than this ratio are annotated. Those below the ratio are excluded. The default value is \code{0.33}.}
}
\value{
A \code{SangerRead} instance.
}
\description{
A SangerRead method which does base calling on SangerRead instance
}
\examples{
data("sangerReadFData")
newSangerReadFData <- MakeBaseCalls(sangerReadFData, signalRatioCutoff = 0.22)
}
