% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{mergedKmerSubPeaks}
\alias{mergedKmerSubPeaks}
\title{Identify and merge k-mer sub-peaks within multi-motif domains}
\usage{
mergedKmerSubPeaks(sarks, filters, thresholds, peakify = TRUE,
    kMax = 12L)
}
\arguments{
\item{sarks}{Sarks object to use for k-mer peak calling.}

\item{filters}{output from sarksFilters function indicating what
combinations of filter parameters halfWindow, spatialLength,
and minGini to use.}

\item{thresholds}{output from permutationThresholds specifying
thresholds for k-mer peak calling.}

\item{peakify}{logical value specifying whether to restrict initial
k-mer peak calling to only spatial positions at which the
smoothed score is at least as high as either neighboring
position (or not).}

\item{kMax}{integer value indicating the maximum k-mer length for
initial k-mer peak calling.}
}
\value{
data.frame containing called k-mer peak information.
}
\description{
When spatials smoothing is employed, SArKS identifies spatial
windows containing elevated spatially-averaged sequence-smoothed
scores (multi-motif domains, or MMDs). This function finds k-mers
within these MMDs whose sequence-smoothed scores are above the
threshold used for MMD calling and merges such k-mers when their
spatial positions overlap.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 3, 1)
filters <- sarksFilters(halfWindow=4, spatialLength=3, minGini=1.1)
permDist <- permutationDistribution(sarks, 250, filters, seed=123)
thresholds <- permutationThresholds(filters, permDist, nSigma=4.0)
mergedSubPeaks <- mergedKmerSubPeaks(sarks, filters, thresholds)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
