% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarks.R
\name{sarksFilters}
\alias{sarksFilters}
\title{Smoothing window and Gini impurity filter settings}
\usage{
sarksFilters(halfWindow, spatialLength, minGini = 1.1)
}
\arguments{
\item{halfWindow}{integer vector of halfWindow values to test.}

\item{spatialLength}{integer vector of spatialLength values to
test; use a single 0 value to disable spatial smoothing.}

\item{minGini}{numeric vector giving minimum Gini impurity value(s)
for suffix position to be analyzed; use a value above 1 to
calculate minimum Gini impurity based on median of observed
Gini impurities so as to constrain variance under permutation
testing to less than minGini multiples of median variance.}
}
\value{
R representation of java object containing specified
    combinations of filter parameters for running permutation
    tests.
}
\description{
Sarks methodology involves testing a range of different filter
parameter values; sarksFilters builds set of filters with all
combinations of desired halfWindow, spatialLength, and minGini
values.
}
\examples{
data(simulatedSeqs, simulatedScores)
sarks <- Sarks(simulatedSeqs, simulatedScores, 4, 0, 1)
filters <- sarksFilters(
        halfWindow=c(4, 8), spatialLength=c(0, 5), minGini=1.1)

}
\references{
Wylie, D.C., Hofmann, H.A., and Zemelman, B.V. (2019)
    SArKS: de novo discovery of gene expression regulatory motif
    sites and domains by suffix array kernel smoothing,
    Bioinformatics, Vol. 35(20), 3944-3952

    \url{https://academic.oup.com/bioinformatics/article-abstract/35/20/3944/5418797}
}
