% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processFCS.R
\name{processFCS}
\alias{processFCS}
\title{Input, filter, normalise, and transform FCS expression data.}
\usage{
processFCS(
  files,
  assayname = "scaled",
  metadata = NULL,
  filter = TRUE,
  bgNoiseThreshold = 1,
  euclideanNormThreshold = 1,
  transformation = TRUE,
  transFun = function(x) asinh(x),
  asinhFactor = 5,
  downsample = 1e+05,
  downsampleVar = 0.1,
  colsDiscard = NULL,
  colsRetain = NULL,
  newColnames = NULL,
  emptyValue = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{files}{A vector of FCS files.}

\item{assayname}{Name of the assay slot in which data will be stored.}

\item{metadata}{Metadata associated with the FCS files specified in
'files'. A strict rule is enforced requiring that \code{rownames(metadata)}
matches files in both name and order.}

\item{filter}{Boolean (TRUE / FALSE) to enable filtering (per sample)
for background signal / noise.}

\item{bgNoiseThreshold}{Threshold for background noise. Used when 
\code{filter == TRUE}.}

\item{euclideanNormThreshold}{Euclidean norm threshold for background
noise. Used when \code{filter == TRUE}.}

\item{transformation}{Boolean (TRUE / FALSE) to enable data transformation
after filtering.}

\item{transFun}{The function to apply (per sample) for transformation. 
Typically, for flow and mass cytometry, this is hyperbolic arc sine
(\code{asinh(x)}). User can supply any function.}

\item{asinhFactor}{The factor to apply when transforming via \code{asinh()}. For
flow cytometry, this is usually 150; for mass cytometry and CyTOF, it is
5. Note that this is not used if the user has supplied their own function
to \code{transFun}.}

\item{downsample}{Downsample to this number of random variables. This is
performed on the final merged dataset, i.e., after all samples have been
bound together. NULL to disable.}

\item{downsampleVar}{Downsample based on variance. Removes this proportion of
cells based on lesser variance. This is applied per sample. If user wishes
to apply this globally on the final merged dataset, then set this to 0 and
remove based on variance manually.}

\item{colsDiscard}{Columns to be removed from the final merged data. These
names are literal and must match exactly.}

\item{colsRetain}{Retain these columns only. This is the same as \code{colsDiscard}
but in reverse. Technically, it is possible to activate both \code{colsDiscard}
and \code{colsRetain}, but \code{colsDiscard} will be executed first.}

\item{newColnames}{A named vector of new marker names to assign to each sample.
The values of this vector should be the new marker names; the names of this
vector should represent the ooriginal marker names. This operation is performed
AFTER any operation involving \code{colsDiscard} and \code{colsRetain}.}

\item{emptyValue}{boolean (taken from ?flowCore::read.FCS indicating whether or
not we allow an empty value for keyword values in TEXT segment.}

\item{verbose}{Boolean (TRUE / FALSE) to print messages to console or not.}
}
\value{
A \code{SingleCellExperiment} object.
}
\description{
Input, filter, normalise, and transform FCS expression data.
}
\details{
Input, filter, normalise, and transform FCS expression data.
}
\examples{
# create random data that follows a negative binomial
mat1 <- jitter(matrix(
  MASS::rnegbin(rexp(50000, rate=.1), theta = 4.5),
  ncol = 20))
colnames(mat1) <- paste0('CD', 1:ncol(mat1))
rownames(mat1) <- paste0('cell', 1:nrow(mat1))

mat2 <- jitter(matrix(
  MASS::rnegbin(rexp(50000, rate=.1), theta = 4.5),
  ncol = 20))
colnames(mat2) <- paste0('CD', 1:ncol(mat2))
rownames(mat2) <- paste0('cell', 1:nrow(mat2))

metadata <- data.frame(
  group = c('PB1', 'PB2'),
  row.names = c('mat1', 'mat2'),
  stringsAsFactors = FALSE)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
