% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cvs.R
\name{calculate_cvs}
\alias{calculate_cvs}
\title{Compute mean expression level, standard deviation and coefficient of
variation of each feature.}
\usage{
calculate_cvs(data, max_zeros = 0.75, sce_assay = NULL)
}
\arguments{
\item{data}{A data frame, a matrix or a \code{SingleCellExperiment} object.
If data frame or matrix, it should contain expression values for each gene as rows, and
expression values for the cells as columns.}

\item{max_zeros}{A number between 0 and 1 indicating the maximum proportion of zero expression values
allowed per row. Features with a higher proportion of 0 will be discarded.}

\item{sce_assay, }{if \code{data} is an \code{SingleCellExperiment} object,
\code{sce_assay} should be one of \code{names(assays(<SingleCellExperiment>))}.}
}
\value{
A data frame, containing the filtered data with additional columns: mean, standard deviation and cv
values for each row.
}
\description{
Compute mean expression level, standard deviation and
coefficient of variation (CV)
of each feature (i.e. gene or transcript) in the supplied data.
Filter features with high proportion of 0 expression.
}
\details{
Before CV computation, the function
removes all rows that have a proportion of zeros above the specified
threshold. Genes with many 0s are poorly informative, and would bias the later correlations.
Removing them also prevents division by zero when calculating CVs.

The data provided must cell/sample names as column names. Feature name can be
 given either in the first column or as row names.

In the output, mean, standard deviation and CV are incorporated as new columns in the data
frame, named \code{mean}, \code{sd} and \code{cv}.
}
\examples{
expMat <- matrix(
    c(1, 1, 1,
      1, 2, 3,
      0, 1, 2,
      0, 0, 2),
    ncol = 3, byrow = TRUE, dimnames = list(paste("gene", 1:4), paste("cell", 1:3))
)
calculate_cvs(expMat)
calculate_cvs(expMat, max_zeros = 0.5)

}
