% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CORE_clustering.R
\name{sub_clustering}
\alias{sub_clustering}
\title{sub_clustering for selected cells}
\usage{
sub_clustering(
  object = NULL,
  ngenes = 1500,
  windows = seq(from = 0.025, to = 1, by = 0.025),
  select_cell_index = NULL
)
}
\arguments{
\item{object}{is a \linkS4class{SingleCellExperiment} object from the
train mixed population}

\item{ngenes}{number of genes used for clustering calculations.}

\item{windows}{a numeric vector specifying the ranges of each window.}

\item{select_cell_index}{a vector containing indexes for cells in selected 
clusters to be reclustered}
}
\value{
clustering results
}
\description{
performs 40 clustering runs or more depending on windows
}
\examples{
day5 <- day_5_cardio_cell_sample
mixedpop2 <-new_summarized_scGPS_object(ExpressionMatrix = day5$dat5_counts, 
    GeneMetadata = day5$dat5geneInfo, CellMetadata = day5$dat5_clusters)
test_sub_clustering <-sub_clustering(mixedpop2,
    select_cell_index = c(seq_len(100)))
}
\author{
Quan Nguyen, 2018-01-31
}
