% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.scHiCcompare.R
\name{print.scHiCcompare}
\alias{print.scHiCcompare}
\title{Print method for `scHiCcompare` objects}
\usage{
\method{print}{scHiCcompare}(x, ...)
}
\arguments{
\item{x}{An object of class `scHiCcompare`. This object should contain
intermediate results from the differential analysis of single-cell
Hi-C data.}

\item{...}{Further arguments to be passed to or from other methods.}
}
\value{
This function does not return any value. It is called for its
 side effect, which is printing a summary of the `scHiCcompare` object.
}
\description{
This method is used to print a summary of the `scHiCcompare` object.
It provides an overview of the number of cells in each condition, the
chromosome analyzed, and the processes involved in the analysis.
}
\examples{
## Load example data for ODC and MG file paths
ODCs_example <- system.file("extdata/ODCs_example",
  package = "scHiCcompare"
)
MGs_example <- system.file("extdata/MGs_example",
  package = "scHiCcompare"
)

## Run scHiCcompare on example data
result <- scHiCcompare(
  file.path.1 = MGs_example,
  file.path.2 = ODCs_example,
  select.chromosome = "chr20",
  Plot = FALSE
)
print(result)

}
