% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrapRandomEffects.R
\name{bootstrapRandomEffects}
\alias{bootstrapRandomEffects}
\title{Generate bootstrapped confidence intervals for random effects.}
\usage{
bootstrapRandomEffects(
  glmm.mod = NULL,
  id.vec = NULL,
  Y.offset = NULL,
  n.boot = 500L,
  alpha = 0.05,
  n.cores = 4L,
  random.seed = 312,
  verbose = TRUE
)
}
\arguments{
\item{glmm.mod}{The output from \code{\link{fitGLMM}}. Defaults to NULL.}

\item{id.vec}{A vector of subject IDs. Defaults to NULL.}

\item{Y.offset}{An offset to be included in the final model fit. Defaults
to NULL.}

\item{n.boot}{(Optional) The number of bootstrap resamples to generate.
Defaults to 500.}

\item{alpha}{(Optional) The desired confidence level. Defaults to good
old 0.05.}

\item{n.cores}{(Optional) The number of threads to use in parallel
processing of the bootstrap resampling procedure. Defaults to 4.}

\item{random.seed}{(Optional) The seed used to control stochasticity
during bootstrap resampling. Defaults to 312.}

\item{verbose}{(Optional) A boolean indicating whether a progress bar
should be printed to the console. Defaults to TRUE.}
}
\value{
An object of class \code{data.frame} containing the upper and
lower quantiles of the per-subject random effects.
}
\description{
This function leverages the parametric bootstrap to generate
empirical confidence intervals for the random effects terms of a
fitted model.
}
\examples{
data(sim_counts)
data(sim_pseudotime)
cell_offset <- createCellOffset(sim_counts)
glmm_mod <- fitGLMM(
    X_pred = sim_pseudotime,
    Y = BiocGenerics::counts(sim_counts)[4, ],
    Y.offset = cell_offset,
    id.vec = sim_counts$subject,
    return.basis = TRUE
)
ranef_sumy <- bootstrapRandomEffects(glmm_mod,
    id.vec = sim_counts$subject,
    Y.offset = cell_offset,
    n.boot = 10L,  # in practice use a larger number such as 500
    n.cores = 1L
)
}
\seealso{
\code{\link{fitGLMM}}

\code{\link[glmmTMB]{glmmTMB}}
}
\author{
Jack R. Leary
}
