% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneProgramSignificance.R
\name{geneProgramSignificance}
\alias{geneProgramSignificance}
\title{Test significance of gene program enrichment across a trajectory.}
\usage{
geneProgramSignificance(
  gene.programs = NULL,
  pt = NULL,
  program.labels = NULL,
  p.adj.method = "holm"
)
}
\arguments{
\item{gene.programs}{A list of vectors of program scores as returned by 
\code{\link{geneProgramScoring}}. Defaults to NULL.}

\item{pt}{A vector of pseudotime values for each cell. May contain NAs, 
which are handled internally. Defaults to NULL.}

\item{program.labels}{(Optional) A character vector specifying a label for 
each gene cluster. Defaults to NULL.}

\item{p.adj.method}{(Optional) The method used to adjust \emph{p}-values 
for multiple hypothesis testing. Defaults to "holm".}
}
\value{
A table of statistical output showing the significance of the 
association between pseudotime and program scores.
}
\description{
This function fits a Beta GAM with pseudotime as a covariate 
and gene program score as the response. The fitted model is then compared 
to a null, intercept-only model in order to determine the significance of 
the relationship between gene program and pseudotime.
}
\details{
\itemize{
\item This function assumes that the gene program scores have been min-max 
normalized to (0, 1) i.e., \emph{not} including the values 0 or 1. This is 
necessary to fit the Beta distribution additive model. This normalization 
can be easily generated by setting the argument \code{minmax.norm = TRUE} 
in the \code{\link{geneProgramScoring}} function.
}
}
\examples{
data(sim_counts)
data(scLANE_models)
data(sim_pseudotime)
smoothed_dynamics <- smoothedCountsMatrix(scLANE_models,
    pt = sim_pseudotime,
    n.cores = 1L
)
gene_embed <- embedGenes(smoothed_dynamics$Lineage_A, n.cores = 1L)
sim_counts <- geneProgramScoring(sim_counts,
    genes = gene_embed$gene,
    gene.clusters = gene_embed$leiden,
    n.cores = 1L
)
program_enrichment_stats <- geneProgramSignificance(list(sim_counts$cluster_0),
    pt = sim_pseudotime$PT,
    program.labels = c("Program Name")
)
}
\seealso{
\code{\link{geneProgramScoring}}
}
\author{
Jack R. Leary
}
