% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullNullSummary.R
\name{pullNullSummary}
\alias{pullNullSummary}
\title{Generate a summary of the null model.}
\usage{
pullNullSummary(
  null.model = NULL,
  is.gee = FALSE,
  sandwich.var = FALSE,
  is.glmm = FALSE
)
}
\arguments{
\item{null.model}{The null model from \code{\link{marge2}}. Defaults to NULL.}

\item{is.gee}{Boolean specifying whether GEE mode was used in fitting the 
null model. Defaults to FALSE.}

\item{sandwich.var}{Boolean specifying whether the robust sandwich 
variance-covariance matrix should be used. Defaults to FALSE.}

\item{is.glmm}{Boolean specifying whether the GLMM mode was used in fitting 
the model. Defaults to FALSE.}
}
\value{
A list containing a coefficient summary, fitted values and their 
standard errors, and the log-likelihood and deviance of the model.
}
\description{
This function takes in the null model fitted during the running
 of \code{\link{marge2}} and summarizes it.
}
\seealso{
\code{\link{marge2}}
}
\author{
Jack R. Leary

Rhonda Bacher
}
