% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_scLANE.R
\name{theme_scLANE}
\alias{theme_scLANE}
\title{A \code{ggplot2} theme for \code{scLANE}.}
\usage{
theme_scLANE(
  base.size = 12,
  base.lwd = 0.75,
  base.family = "sans",
  umap = FALSE
)
}
\arguments{
\item{base.size}{The base font size. Defaults to 12.}

\item{base.lwd}{The base linewidth. Defaults to 0.75.}

\item{base.family}{The font family to be used throughout. Defaults to "sans".}

\item{umap}{(Optional) If set to TRUE, removes axis text and ticks for a 
cleaner look. Defaults to FALSE.}
}
\value{
A \code{ggplot2} theme.
}
\description{
A publication-ready theme for creating gene dynamics plots, 
embedding plots, etc.
}
\examples{
data(sim_counts)
data(scLANE_models)
data(sim_pseudotime)
cell_offset <- createCellOffset(sim_counts)
model_plot <- plotModels(scLANE_models,
    gene = names(scLANE_models)[1],
    pt = sim_pseudotime,
    expr.mat = sim_counts,
    size.factor.offset = cell_offset
) +
    theme_scLANE()
}
\author{
Jack R. Leary
}
