% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plots.R
\name{scmet_plot_vf_tail_prob}
\alias{scmet_plot_vf_tail_prob}
\title{Plot tail probabilities for variable feature analysis}
\usage{
scmet_plot_vf_tail_prob(
  obj,
  x = "mu",
  task = "hvf",
  title = NULL,
  nfeatures = NULL
)
}
\arguments{
\item{obj}{The scMET object after calling the \code{\link{scmet_hvf_lvf}}
function.}

\item{x}{The parameter to plot on the x-axis. Values can be \code{mu} (default),
\code{epsilon} or \code{gamma}.}

\item{task}{The task for identifying variable, either "hvf" or "lvf".}

\item{title}{Optional title, default NULL.}

\item{nfeatures}{Optional parameter, denoting a subset of number of features
to plot (only for non HVF/LVF features). Mostly to reduce over-plotting.}
}
\value{
A ggplot2 object.
}
\description{
Function for plotting the tail probabilities associated with the
HVF/LVF analysis. The tail probabilities are plotted on the y-axis, and the
user can choose which parameter can be plotted on the x-axis, using the \code{x}
parameter.
}
\examples{
# Fit scMET
obj <- scmet(Y = scmet_dt$Y, X = scmet_dt$X, L = 4, iter = 100)
obj <- scmet_hvf(scmet_obj = obj, delta_e = 0.7)
scmet_plot_vf_tail_prob(obj = obj, x = "mu")

}
\seealso{
\code{\link{scmet}}, \code{\link{scmet_differential}},
\code{\link{scmet_hvf_lvf}}, \code{\link{scmet_plot_mean_var}},
\code{\link{scmet_plot_efdr_efnr_grid}}, \code{\link{scmet_plot_volcano}},
\code{\link{scmet_plot_ma}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
