% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCPCA.R
\name{fitCPCA}
\alias{fitCPCA}
\title{Contrastive Principal Component Analysis}
\usage{
fitCPCA(
  target,
  center,
  scale,
  c_contrasts,
  contrasts,
  n_eigen,
  n_medoids,
  eigdecomp_tol,
  eigdecomp_iter
)
}
\arguments{
\item{target}{The target (experimental) data set, in a standard format such
as a \code{data.frame} or \code{matrix}.}

\item{center}{A \code{logical} indicating whether the target and background
data sets should be centered to mean zero.}

\item{scale}{A \code{logical} indicating whether the target and background
data sets should be scaled to unit variance.}

\item{c_contrasts}{A \code{list} of contrastive covariances.}

\item{contrasts}{A \code{numeric} vector of the contrastive parameters used
to compute the contrastive covariances.}

\item{n_eigen}{A \code{numeric} indicating the number of eigenvectors to be
computed.}

\item{n_medoids}{A \code{numeric} indicating the number of medoids to
consider. Not used if  \code{contrasts} is a single value.}

\item{eigdecomp_tol}{A \code{numeric} providing the level of precision used by
eigendecompositon calculations. Defaults to \code{1e-10}.}

\item{eigdecomp_iter}{A \code{numeric} indicating the maximum number of
interations performed by eigendecompositon calculations. Defaults to
\code{1000}.}
}
\value{
A list of lists containing the cPCA results for each contrastive
  parameter deemed to be a medoid.
  \itemize{
    \item rotation - the list of matrices of variable loadings
    \item x - the list of rotated data, centred and scaled if requested,
    multiplied by the rotation matrix
    \item contrast - the list of contrastive parameters
    \item penalty - set to zero, since loadings are not penalized in cPCA
  }
}
\description{
Given target and background dataframes or matrices, \code{cPCA}
  will perform contrastive principal component analysis (cPCA) of the target
  data for a given number of eigenvectors and a vector of real valued
  contrast parameters. This is identical to the implementation of cPCA
  method of \insertCite{abid2018exploring;textual}{scPCA}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
